/*
 * Decompiled with CFR 0.152.
 */
package usbsetparaupgdataapp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;

public class UsbSetParaUpgDataApp
extends JFrame {
    private Thread Thread1 = new Thread();
    private File UpdateFile;
    private MidiDevice MidiDeviceOutput = null;
    private MidiDevice MidiDeviceInput = null;
    private Receiver MidiDeviceReceiver = null;
    private Transmitter MidiDeviceTransmitter = null;
    private FileDialog FileDialog;
    private MidiDevice.Info[] MidiDeviceList;
    private SysexMessage SysexMsg = new SysexMessage();
    private int MidiDeviceCnt;
    private int[] MidiShowList;
    private MidiDevice.Info OutputIndex;
    private MidiDevice.Info InputIndex;
    private byte[] SysexDataArr = new byte[130];
    private String AppPath = System.getProperty("user.dir");
    private String DirFile;
    private String MsgStr;
    private int SendDataAdd;
    private int RxAddressFlag;
    private int HighByteAdd;
    private int MidByteAdd;
    private int LowByteAdd;
    private int CheckSumVolume;
    private int SendReadyCnt;
    private Boolean DeviceStateFlag;
    private Boolean ParaStateFlag;
    private Boolean PausedStartFlag;
    private Boolean UpdateStartFlag;
    private Boolean BootLoadModeFlag;
    private int ChannelState;
    private Boolean ControllerMode;
    private Boolean ShiftState;
    private Boolean SampleState;
    private Boolean KillState;
    private Boolean UpdateFlag;
    private JButton ButtonGet;
    private JButton ButtonInit;
    private JButton ButtonOpenFile;
    private JButton ButtonSet;
    private JButton ButtonStart;
    private JComboBox ComboBoxChannel;
    private JLabel LabeDspVersion;
    private JLabel LabelChannelState;
    private JLabel LabelControlVersion;
    private JLabel LabelControllerMode;
    private JLabel LabelControllerMode1;
    private JLabel LabelFirmwareUpgrade;
    private JLabel LabelFirmwareVersion;
    private JLabel LabelKillState;
    private JLabel LabelModelNo;
    private JLabel LabelSampleState;
    private JLabel LabelSetting;
    private JLabel LabelShiftState;
    private JLabel LabelTitleName;
    private JLabel LabelVersion;
    private JLabel LabelVersion1;
    private JLabel LableUpdateFile;
    private JPanel PanelMain;
    private JRadioButton RadioButtonKill0;
    private JRadioButton RadioButtonKill1;
    private JRadioButton RadioButtonSample0;
    private JRadioButton RadioButtonSample1;
    private JRadioButton RadioButtonShift0;
    private JRadioButton RadioButtonShift1;
    private JTextArea TextAreaShowMsg;
    private JTextField TextUpdateFile;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup10;
    private ButtonGroup buttonGroup11;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private ButtonGroup buttonGroup6;
    private ButtonGroup buttonGroup7;
    private ButtonGroup buttonGroup8;
    private ButtonGroup buttonGroup9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public UsbSetParaUpgDataApp() {
        this.initComponents();
        this.initEvent();
        this.getMidiDeviceInfo();
    }

    public void initEvent() {
        this.SendReadyCnt = 0;
        this.DirFile = "";
        this.DeviceStateFlag = false;
        this.ParaStateFlag = false;
        this.PausedStartFlag = false;
        this.UpdateStartFlag = false;
        this.BootLoadModeFlag = false;
        this.UpdateFlag = false;
        this.ChannelState = 0;
        this.ShiftState = false;
        this.SampleState = false;
        this.ControllerMode = false;
        this.KillState = false;
        this.ComboBoxChannel.setSelectedIndex(0);
        this.RadioButtonShift0.setSelected(true);
        this.RadioButtonShift1.setSelected(false);
        this.RadioButtonSample0.setSelected(true);
        this.RadioButtonSample1.setSelected(false);
        this.RadioButtonKill0.setSelected(true);
        this.RadioButtonKill1.setSelected(false);
        this.LabeDspVersion.setText("DSP Version :");
        this.LabelControlVersion.setText("Control Version :");
        this.LabelTitleName.setText("No Device");
        this.TextUpdateFile.setText("");
        this.TextAreaShowMsg.setText("");
        this.TextAreaShowMsg.setForeground(Color.blue);
        this.setParameterState(false);
        this.setFirmwareUpgrade(false);
    }

    public void setParameterState(boolean flag) {
        this.LabelModelNo.setEnabled(flag);
        this.LabelControllerMode.setEnabled(flag);
        this.LabelChannelState.setEnabled(flag);
        this.ComboBoxChannel.setEnabled(flag);
        this.LabelSetting.setEnabled(flag);
        this.LabelShiftState.setEnabled(flag);
        this.RadioButtonShift0.setEnabled(flag);
        this.RadioButtonShift1.setEnabled(flag);
        this.LabelSampleState.setEnabled(flag);
        this.RadioButtonSample0.setEnabled(flag);
        this.RadioButtonSample1.setEnabled(flag);
        this.LabelKillState.setEnabled(flag);
        this.RadioButtonKill0.setEnabled(flag);
        this.RadioButtonKill1.setEnabled(flag);
        this.LabelFirmwareVersion.setEnabled(flag);
        this.LabeDspVersion.setEnabled(flag);
        this.ButtonGet.setEnabled(flag);
        this.LabelControlVersion.setEnabled(flag);
        this.ButtonSet.setEnabled(flag);
    }

    public void setFirmwareUpgrade(boolean flag) {
        this.LabelFirmwareUpgrade.setEnabled(flag);
        this.LableUpdateFile.setEnabled(flag);
        this.TextUpdateFile.setEnabled(flag);
        this.ButtonOpenFile.setEnabled(flag);
        this.ButtonOpenFile.setEnabled(flag);
        this.ButtonStart.setEnabled(flag);
    }

    public void closeInputOutputDevice() {
        if (this.MidiDeviceCnt == 0) {
            return;
        }
        if (this.MidiDeviceInput.isOpen()) {
            this.MidiDeviceInput.close();
        }
        if (this.MidiDeviceOutput.isOpen()) {
            this.MidiDeviceOutput.close();
        }
    }

    public void getMidiDeviceInfo() {
        int i;
        String OldName1 = "";
        this.MidiDeviceCnt = 0;
        this.MidiDeviceList = MidiSystem.getMidiDeviceInfo();
        this.MidiShowList = new int[this.MidiDeviceList.length];
        for (i = 0; i < this.MidiDeviceList.length; ++i) {
            try {
                String Name1;
                MidiDevice Device1 = MidiSystem.getMidiDevice(this.MidiDeviceList[i]);
                if (Device1.getMaxTransmitters() == 0 || OldName1.equals(Name1 = this.MidiDeviceList[i].getName().trim())) continue;
                for (int j = 0; j < this.MidiDeviceList.length; ++j) {
                    try {
                        String Name2;
                        MidiDevice Device2 = MidiSystem.getMidiDevice(this.MidiDeviceList[j]);
                        if (Device2.getMaxReceivers() == 0 || !Name1.equals(Name2 = this.MidiDeviceList[j].getName().trim())) continue;
                        this.MidiShowList[this.MidiDeviceCnt++] = i;
                        break;
                    }
                    catch (MidiUnavailableException e) {
                        // empty catch block
                    }
                }
                OldName1 = Name1;
                continue;
            }
            catch (MidiUnavailableException e) {
                // empty catch block
            }
        }
        if (this.MidiDeviceCnt > 0) {
            for (i = 0; i < this.MidiDeviceCnt; ++i) {
                this.getInputOutputEvent(i);
                try {
                    this.sendShortMessage(160, 127, 0);
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.DeviceStateFlag.booleanValue()) break;
            }
        }
    }

    public void getInputOutputEvent(int index) {
        try {
            this.InputIndex = this.MidiDeviceList[this.MidiShowList[index]];
            this.MidiDeviceInput = MidiSystem.getMidiDevice(this.InputIndex);
            this.MidiDeviceInput.open();
            this.MidiDeviceTransmitter = this.MidiDeviceInput.getTransmitter();
            String inputName = this.InputIndex.getName().trim();
            for (int i = 0; i < this.MidiDeviceList.length; ++i) {
                String outputName = this.MidiDeviceList[i].getName().trim();
                if (!inputName.equals(outputName)) continue;
                try {
                    MidiDevice device = MidiSystem.getMidiDevice(this.MidiDeviceList[i]);
                    if (device.getMaxReceivers() == 0) continue;
                    this.OutputIndex = this.MidiDeviceList[i];
                    this.MidiDeviceOutput = MidiSystem.getMidiDevice(this.OutputIndex);
                    this.MidiDeviceOutput.open();
                    this.MidiDeviceReceiver = this.MidiDeviceOutput.getReceiver();
                    break;
                }
                catch (MidiUnavailableException e) {
                    // empty catch block
                }
            }
            this.usbRxInputDataEvent();
        }
        catch (MidiUnavailableException e) {
            // empty catch block
        }
    }

    public void getUpdateFileEvent() {
        if (this.DirFile.isEmpty()) {
            this.TextAreaShowMsg.setForeground(Color.blue);
            this.TextAreaShowMsg.setText(" >>>Select Update File is empty");
            JOptionPane.showMessageDialog(null, "Select Update File is empty");
        } else {
            this.UpdateFile = new File(this.DirFile);
            if (this.UpdateFile.exists()) {
                this.SendReadyCnt = 0;
                this.PausedStartFlag = true;
            } else {
                JOptionPane.showMessageDialog(null, "update file " + this.UpdateFile + " is not exist");
            }
        }
    }

    public void usbRxInputDataEvent() {
        this.MidiDeviceTransmitter.setReceiver(new Receiver(){

            public void close() {
                System.err.println("midi close");
            }

            public void send(MidiMessage message, long ts) {
                if (message instanceof ShortMessage) {
                    UsbSetParaUpgDataApp.this.decodeMessage((ShortMessage)message);
                } else if (message instanceof SysexMessage) {
                    UsbSetParaUpgDataApp.this.decodeMessage((SysexMessage)message);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decodeMessage(ShortMessage message) {
        switch (message.getCommand()) {
            case 160: {
                switch (message.getChannel()) {
                    case 0: {
                        switch (message.getData1()) {
                            case 1: {
                                this.ComboBoxChannel.setSelectedIndex(message.getData2());
                                this.ComboBoxChannel.setEnabled(true);
                                this.ChannelState = message.getData2();
                                break;
                            }
                            case 2: {
                                if (message.getData2() == 0) {
                                    this.ShiftState = false;
                                    this.RadioButtonShift0.setSelected(true);
                                    this.RadioButtonShift1.setSelected(false);
                                    break;
                                }
                                this.ShiftState = true;
                                this.RadioButtonShift0.setSelected(false);
                                this.RadioButtonShift1.setSelected(true);
                                break;
                            }
                            case 3: {
                                if (message.getData2() == 0) {
                                    this.SampleState = false;
                                    this.RadioButtonSample0.setSelected(true);
                                    this.RadioButtonSample1.setSelected(false);
                                    break;
                                }
                                this.SampleState = true;
                                this.RadioButtonSample0.setSelected(false);
                                this.RadioButtonSample1.setSelected(true);
                                break;
                            }
                            case 4: {
                                this.MsgStr = Integer.toHexString(message.getData2()) + ".";
                                break;
                            }
                            case 5: {
                                this.MsgStr = this.MsgStr + Integer.toHexString(message.getData2());
                                break;
                            }
                            case 6: {
                                this.MsgStr = this.MsgStr + Integer.toHexString(message.getData2());
                                this.LabeDspVersion.setText("DSP Version : " + this.MsgStr);
                                break;
                            }
                            case 7: {
                                this.MsgStr = Integer.toHexString(message.getData2()) + ".";
                                break;
                            }
                            case 8: {
                                this.MsgStr = this.MsgStr + Integer.toHexString(message.getData2());
                                break;
                            }
                            case 9: {
                                this.MsgStr = this.MsgStr + Integer.toHexString(message.getData2());
                                this.LabelControlVersion.setText("Control Version : " + this.MsgStr);
                                break;
                            }
                            case 10: {
                                if (message.getData2() == 0) {
                                    this.ControllerMode = false;
                                    break;
                                }
                                this.ControllerMode = true;
                                break;
                            }
                            case 11: {
                                if (message.getData2() == 0) {
                                    this.KillState = false;
                                    this.RadioButtonKill0.setSelected(true);
                                    this.RadioButtonKill1.setSelected(false);
                                    break;
                                }
                                this.KillState = true;
                                this.RadioButtonKill0.setSelected(false);
                                this.RadioButtonKill1.setSelected(true);
                                break;
                            }
                            case 127: {
                                if (!this.ParaStateFlag.booleanValue()) return;
                                this.MsgStr = "set parameters success!!!";
                                this.TextAreaShowMsg.setForeground(Color.red);
                                this.TextAreaShowMsg.setText(" >>> " + this.MsgStr);
                                JOptionPane.showMessageDialog(null, this.MsgStr);
                                this.sendShortMessage(160, 127, 1);
                                this.ParaStateFlag = false;
                                return;
                            }
                        }
                        break;
                    }
                    case 1: {
                        this.HighByteAdd = message.getData1() << 4 | message.getData2() & 0xF;
                        this.SendDataAdd = this.HighByteAdd << 16;
                        this.RxAddressFlag = 1;
                        break;
                    }
                    case 2: {
                        if (this.RxAddressFlag != 1) return;
                        this.MidByteAdd = message.getData1() << 4 | message.getData2() & 0xF;
                        this.SendDataAdd |= this.MidByteAdd << 8;
                        this.RxAddressFlag = 2;
                        break;
                    }
                    case 3: {
                        if (this.RxAddressFlag != 2) return;
                        this.LowByteAdd = message.getData1() << 4 | message.getData2() & 0xF;
                        this.SendDataAdd |= this.LowByteAdd;
                        this.UpdateStartFlag = true;
                        this.MsgStr = " >>> Request Address:0x" + Integer.toHexString(this.SendDataAdd) + "\n\n";
                        this.sendShortMessage(161, (this.HighByteAdd & 0xF0) >> 4, this.HighByteAdd & 0xF);
                        this.sendShortMessage(162, (this.MidByteAdd & 0xF0) >> 4, this.MidByteAdd & 0xF);
                        this.sendShortMessage(163, (this.LowByteAdd & 0xF0) >> 4, this.LowByteAdd & 0xF);
                        this.MsgStr = this.MsgStr + " >>> Reply Address:0x" + Integer.toHexString(this.SendDataAdd) + "\n\n";
                        this.sendSysexMessage();
                        this.sendShortMessage(164, (this.CheckSumVolume & 0xF000) >> 12, (this.CheckSumVolume & 0xF00) >> 8);
                        this.sendShortMessage(165, (this.CheckSumVolume & 0xF0) >> 4, this.CheckSumVolume & 0xF);
                        this.MsgStr = this.MsgStr + " >>> Check Sum Value:0x" + Integer.toHexString(this.CheckSumVolume) + "\n\n";
                        this.MsgStr = this.MsgStr + " >>> Wait,Host send data to Device";
                        this.TextAreaShowMsg.setForeground(Color.blue);
                        this.TextAreaShowMsg.setText(this.MsgStr);
                        this.RxAddressFlag = 0;
                        break;
                    }
                    case 15: {
                        if (message.getData1() != 127) return;
                        this.MsgStr = "";
                        if (message.getData2() == 1) {
                            this.MsgStr = "File Error!!!";
                        } else if (message.getData2() == 2) {
                            this.MsgStr = "Address Error!!!";
                        } else if (message.getData2() == 3) {
                            this.MsgStr = "Data Error!!!";
                        } else if (message.getData2() == 4) {
                            this.MsgStr = "Check Sum Value Error!!!";
                        } else if (message.getData2() == 5) {
                            this.MsgStr = "Update Fail Error!!!";
                        } else if (message.getData2() == 6) {
                            this.MsgStr = "Firmware Upgrade Success!!!";
                        }
                        this.TextAreaShowMsg.setForeground(Color.red);
                        this.TextAreaShowMsg.setText(" >>> " + this.MsgStr);
                        JOptionPane.showMessageDialog(null, this.MsgStr);
                        if (message.getData2() == 6) {
                            this.UpdateFlag = true;
                            break;
                        }
                        this.initEvent();
                        this.closeInputOutputDevice();
                        this.getMidiDeviceInfo();
                    }
                }
                return;
            }
        }
    }

    public void decodeMessage(SysexMessage message) {
        byte[] abData = message.getData();
        this.MsgStr = "";
        int data = 0;
        if (message.getStatus() == 240) {
            for (int i = 0; i < abData.length; ++i) {
                if (i % 2 == 0) {
                    data = abData[i] << 4;
                    continue;
                }
                this.MsgStr = this.MsgStr + Character.toString((char)(data |= abData[i]));
            }
            String str1 = this.MsgStr.substring(0, 2).trim();
            if (str1.equals("HP")) {
                this.LabelTitleName.setText(this.MsgStr.substring(3).trim());
                this.DeviceStateFlag = true;
            }
            this.BootLoadModeFlag = false;
            String str2 = this.MsgStr.substring(0, 3).trim();
            if (str2.equals("HP1")) {
                this.setParameterState(true);
                this.setFirmwareUpgrade(false);
            } else if (str2.equals("HP2")) {
                this.setParameterState(false);
                this.setFirmwareUpgrade(true);
                this.BootLoadModeFlag = true;
            }
        }
    }

    public static String getHexString(byte[] aByte) {
        StringBuffer sbuf = new StringBuffer(aByte.length * 3 + 2);
        for (int i = 0; i < aByte.length; ++i) {
            sbuf.append(' ');
            byte bhigh = (byte)((aByte[i] & 0xF0) >> 4);
            sbuf.append((char)(bhigh > 9 ? bhigh + 65 - 10 : bhigh + 48));
            byte blow = (byte)(aByte[i] & 0xF);
            sbuf.append((char)(blow > 9 ? blow + 65 - 10 : blow + 48));
        }
        return new String(sbuf);
    }

    public void sendShortMessage(int cmd, int data1, int data2) {
        ShortMessage shortMsg = new ShortMessage();
        try {
            shortMsg.setMessage(cmd, data1, data2);
            this.MidiDeviceReceiver.send(shortMsg, -1L);
            Thread.sleep(1L);
        }
        catch (InvalidMidiDataException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void sendReadyDataMsgToControl() {
        int cnt = 0;
        this.MsgStr = "Send Sysex Message Data to Control....................\n\n";
        this.SysexDataArr[cnt++] = -16;
        this.SysexDataArr[cnt++] = 4;
        this.SysexDataArr[cnt++] = 8;
        this.SysexDataArr[cnt++] = 5;
        this.SysexDataArr[cnt++] = 0;
        this.SysexDataArr[cnt++] = 3;
        this.SysexDataArr[cnt++] = 2;
        this.SysexDataArr[cnt++] = 2;
        this.SysexDataArr[cnt++] = 0;
        int len = this.FileDialog.getFile().length();
        byte[] arr = new byte[len];
        arr = this.FileDialog.getFile().getBytes();
        for (int i = 0; i < len; ++i) {
            this.SysexDataArr[cnt++] = (byte)(arr[i] >> 4);
            this.SysexDataArr[cnt++] = (byte)(arr[i] & 0xF);
        }
        this.SysexDataArr[cnt++] = -9;
        this.MsgStr = this.MsgStr + " >>> Send Sysex Message Count : " + this.SendReadyCnt + "\n\n";
        this.MsgStr = this.MsgStr + " >>> Wait,Host send message to Device";
        this.TextAreaShowMsg.setForeground(Color.blue);
        this.TextAreaShowMsg.setText(this.MsgStr);
        try {
            this.SysexMsg.setMessage(this.SysexDataArr, cnt);
            this.MidiDeviceReceiver.send(this.SysexMsg, -1L);
            Thread.sleep(1000L);
        }
        catch (InvalidMidiDataException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void sendSysexMessage() {
        try {
            int readData;
            FileInputStream fileIn = new FileInputStream(this.UpdateFile);
            BufferedInputStream bufIn = new BufferedInputStream(fileIn);
            bufIn.skip(this.SendDataAdd);
            this.SysexDataArr[0] = -16;
            this.SysexDataArr[this.SysexDataArr.length - 1] = -9;
            int arrayCnt = 1;
            this.CheckSumVolume = 0;
            while ((readData = bufIn.read()) != -1) {
                this.SysexDataArr[arrayCnt++] = (byte)(readData >> 4);
                this.SysexDataArr[arrayCnt++] = (byte)(readData & 0xF);
                this.CheckSumVolume += readData;
                if (arrayCnt <= 128) continue;
                this.SysexMsg.setMessage(this.SysexDataArr, this.SysexDataArr.length);
                this.MidiDeviceReceiver.send(this.SysexMsg, -1L);
                Thread.sleep(1L);
                break;
            }
        }
        catch (IOException e) {
        }
        catch (InvalidMidiDataException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.buttonGroup6 = new ButtonGroup();
        this.buttonGroup7 = new ButtonGroup();
        this.buttonGroup8 = new ButtonGroup();
        this.buttonGroup9 = new ButtonGroup();
        this.buttonGroup10 = new ButtonGroup();
        this.buttonGroup11 = new ButtonGroup();
        this.PanelMain = new JPanel();
        this.LabelTitleName = new JLabel();
        this.LabelVersion = new JLabel();
        this.LabelModelNo = new JLabel();
        this.ButtonInit = new JButton();
        this.jSeparator2 = new JSeparator();
        this.LabelControllerMode = new JLabel();
        this.LabelChannelState = new JLabel();
        this.ComboBoxChannel = new JComboBox();
        this.LabelShiftState = new JLabel();
        this.RadioButtonShift0 = new JRadioButton();
        this.RadioButtonShift1 = new JRadioButton();
        this.LabelSampleState = new JLabel();
        this.RadioButtonSample0 = new JRadioButton();
        this.RadioButtonSample1 = new JRadioButton();
        this.LabelKillState = new JLabel();
        this.RadioButtonKill0 = new JRadioButton();
        this.RadioButtonKill1 = new JRadioButton();
        this.LabeDspVersion = new JLabel();
        this.LabelControlVersion = new JLabel();
        this.ButtonGet = new JButton();
        this.ButtonSet = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.LabelSetting = new JLabel();
        this.LabelFirmwareVersion = new JLabel();
        this.jPanel1 = new JPanel();
        this.TextUpdateFile = new JTextField();
        this.LabelFirmwareUpgrade = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.TextAreaShowMsg = new JTextArea();
        this.ButtonOpenFile = new JButton();
        this.ButtonStart = new JButton();
        this.LableUpdateFile = new JLabel();
        this.LabelVersion1 = new JLabel();
        this.LabelControllerMode1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("DJinnseries_manager.jar");
        this.setResizable(false);
        this.PanelMain.setBackground(SystemColor.windowText);
        this.PanelMain.setPreferredSize(new Dimension(480, 1037));
        this.PanelMain.setRequestFocusEnabled(false);
        this.LabelTitleName.setFont(new Font("Arial", 1, 30));
        this.LabelTitleName.setForeground(new Color(255, 255, 255));
        this.LabelTitleName.setHorizontalAlignment(0);
        this.LabelVersion.setFont(new Font("Arial", 1, 12));
        this.LabelVersion.setForeground(Color.red);
        this.LabelVersion.setHorizontalAlignment(0);
        this.LabelVersion.setText("ver1.05");
        this.LabelModelNo.setFont(new Font("Arial", 1, 14));
        this.LabelModelNo.setForeground(new Color(255, 255, 255));
        this.LabelModelNo.setText("model no.:");
        this.ButtonInit.setBackground(new Color(102, 102, 102));
        this.ButtonInit.setFont(new Font("Arial", 1, 14));
        this.ButtonInit.setForeground(new Color(255, 255, 255));
        this.ButtonInit.setText("Initialize");
        this.ButtonInit.setBorder(new SoftBevelBorder(0));
        this.ButtonInit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ButtonInitActionPerformed(evt);
            }
        });
        this.LabelControllerMode.setFont(new Font("Arial", 1, 14));
        this.LabelControllerMode.setForeground(new Color(255, 255, 255));
        this.LabelControllerMode.setText("Controller Mode");
        this.LabelChannelState.setFont(new Font("Arial", 1, 14));
        this.LabelChannelState.setForeground(new Color(255, 255, 255));
        this.LabelChannelState.setText("Channel State :");
        this.ComboBoxChannel.setFont(new Font("Arial", 1, 12));
        this.ComboBoxChannel.setModel(new DefaultComboBoxModel<String>(new String[]{"CH0~CH3", "CH4~CH7", "CH8~CH11", "CH12~CH15"}));
        this.ComboBoxChannel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ComboBoxChannelActionPerformed(evt);
            }
        });
        this.LabelShiftState.setFont(new Font("Arial", 1, 12));
        this.LabelShiftState.setForeground(new Color(255, 255, 255));
        this.LabelShiftState.setText("SHIFT button :");
        this.RadioButtonShift0.setBackground(new Color(0, 0, 0));
        this.RadioButtonShift0.setFont(new Font("Arial", 1, 12));
        this.RadioButtonShift0.setForeground(new Color(255, 255, 255));
        this.RadioButtonShift0.setText("Hold");
        this.RadioButtonShift0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonShift0ActionPerformed(evt);
            }
        });
        this.RadioButtonShift1.setBackground(new Color(0, 0, 0));
        this.RadioButtonShift1.setFont(new Font("Arial", 1, 12));
        this.RadioButtonShift1.setForeground(new Color(255, 255, 255));
        this.RadioButtonShift1.setText("Toggle");
        this.RadioButtonShift1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonShift1ActionPerformed(evt);
            }
        });
        this.LabelSampleState.setFont(new Font("Arial", 1, 12));
        this.LabelSampleState.setForeground(new Color(255, 255, 255));
        this.LabelSampleState.setText("Samples :");
        this.RadioButtonSample0.setBackground(new Color(0, 0, 0));
        this.RadioButtonSample0.setFont(new Font("Arial", 1, 12));
        this.RadioButtonSample0.setForeground(new Color(255, 255, 255));
        this.RadioButtonSample0.setText("Deck");
        this.RadioButtonSample0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonSample0ActionPerformed(evt);
            }
        });
        this.RadioButtonSample1.setBackground(new Color(0, 0, 0));
        this.RadioButtonSample1.setFont(new Font("Arial", 1, 12));
        this.RadioButtonSample1.setForeground(new Color(255, 255, 255));
        this.RadioButtonSample1.setText("Global");
        this.RadioButtonSample1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonSample1ActionPerformed(evt);
            }
        });
        this.LabelKillState.setFont(new Font("Arial", 1, 12));
        this.LabelKillState.setForeground(new Color(255, 255, 255));
        this.LabelKillState.setText("EQ Kill button :");
        this.RadioButtonKill0.setBackground(new Color(0, 0, 0));
        this.RadioButtonKill0.setFont(new Font("Arial", 1, 12));
        this.RadioButtonKill0.setForeground(new Color(255, 255, 255));
        this.RadioButtonKill0.setText("Enable");
        this.RadioButtonKill0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonKill0ActionPerformed(evt);
            }
        });
        this.RadioButtonKill1.setBackground(new Color(0, 0, 0));
        this.RadioButtonKill1.setFont(new Font("Arial", 1, 12));
        this.RadioButtonKill1.setForeground(new Color(255, 255, 255));
        this.RadioButtonKill1.setText("Disable");
        this.RadioButtonKill1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.RadioButtonKill1ActionPerformed(evt);
            }
        });
        this.LabeDspVersion.setFont(new Font("Arial", 1, 14));
        this.LabeDspVersion.setForeground(new Color(255, 255, 255));
        this.LabeDspVersion.setText("DSP Version :");
        this.LabelControlVersion.setFont(new Font("Arial", 1, 14));
        this.LabelControlVersion.setForeground(new Color(255, 255, 255));
        this.LabelControlVersion.setText("Control Version :");
        this.ButtonGet.setBackground(new Color(102, 102, 102));
        this.ButtonGet.setFont(new Font("Arial", 1, 14));
        this.ButtonGet.setForeground(new Color(255, 255, 255));
        this.ButtonGet.setText("Get Info");
        this.ButtonGet.setBorder(new SoftBevelBorder(0));
        this.ButtonGet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ButtonGetActionPerformed(evt);
            }
        });
        this.ButtonSet.setBackground(new Color(102, 102, 102));
        this.ButtonSet.setFont(new Font("Arial", 1, 14));
        this.ButtonSet.setForeground(new Color(255, 255, 255));
        this.ButtonSet.setText("Set");
        this.ButtonSet.setBorder(new SoftBevelBorder(0));
        this.ButtonSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ButtonSetActionPerformed(evt);
            }
        });
        this.LabelSetting.setFont(new Font("Arial", 1, 14));
        this.LabelSetting.setForeground(new Color(255, 255, 255));
        this.LabelSetting.setText("Settings");
        this.LabelFirmwareVersion.setFont(new Font("Arial", 1, 14));
        this.LabelFirmwareVersion.setForeground(new Color(255, 255, 255));
        this.LabelFirmwareVersion.setText("Current Firmware Version");
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanel1.setForeground(new Color(51, 51, 51));
        this.TextUpdateFile.setFont(new Font("Arial", 1, 12));
        this.LabelFirmwareUpgrade.setFont(new Font("Arial", 1, 14));
        this.LabelFirmwareUpgrade.setForeground(new Color(255, 255, 255));
        this.LabelFirmwareUpgrade.setText("Firmware Update");
        this.TextAreaShowMsg.setColumns(20);
        this.TextAreaShowMsg.setEditable(false);
        this.TextAreaShowMsg.setFont(new Font("Arial", 1, 12));
        this.TextAreaShowMsg.setRows(5);
        this.jScrollPane1.setViewportView(this.TextAreaShowMsg);
        this.ButtonOpenFile.setBackground(new Color(102, 102, 102));
        this.ButtonOpenFile.setFont(new Font("Arial", 1, 14));
        this.ButtonOpenFile.setForeground(new Color(255, 255, 255));
        this.ButtonOpenFile.setText("OpenFile");
        this.ButtonOpenFile.setBorder(new SoftBevelBorder(0));
        this.ButtonOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ButtonOpenFileActionPerformed(evt);
            }
        });
        this.ButtonStart.setBackground(new Color(102, 102, 102));
        this.ButtonStart.setFont(new Font("Arial", 1, 18));
        this.ButtonStart.setForeground(new Color(255, 255, 255));
        this.ButtonStart.setText("START");
        this.ButtonStart.setBorder(new SoftBevelBorder(0));
        this.ButtonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UsbSetParaUpgDataApp.this.ButtonStartActionPerformed(evt);
            }
        });
        this.LableUpdateFile.setFont(new Font("Arial", 1, 14));
        this.LableUpdateFile.setForeground(new Color(255, 255, 255));
        this.LableUpdateFile.setText("Selected File :");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.LableUpdateFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TextUpdateFile, -1, 312, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 300, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ButtonOpenFile, -2, 100, -2).addComponent(this.ButtonStart, -2, 100, -2)))).addContainerGap()).addComponent(this.LabelFirmwareUpgrade, -2, 145, -2))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelFirmwareUpgrade).addComponent(this.ButtonOpenFile, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LableUpdateFile).addComponent(this.TextUpdateFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE).addComponent(this.ButtonStart, -2, 55, -2)).addContainerGap()));
        this.LabelVersion1.setFont(new Font("Arial", 1, 18));
        this.LabelVersion1.setForeground(Color.red);
        this.LabelVersion1.setHorizontalAlignment(2);
        this.LabelVersion1.setIcon(new ImageIcon(this.getClass().getResource("/picture/Hitmusic.jpg")));
        this.LabelControllerMode1.setFont(new Font("Arial", 1, 14));
        this.LabelControllerMode1.setForeground(new Color(255, 255, 255));
        this.LabelControllerMode1.setText("MIDI Mode");
        GroupLayout PanelMainLayout = new GroupLayout(this.PanelMain);
        this.PanelMain.setLayout(PanelMainLayout);
        PanelMainLayout.setHorizontalGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelMainLayout.createSequentialGroup().addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator2, -2, 420, -2).addGroup(GroupLayout.Alignment.LEADING, PanelMainLayout.createSequentialGroup().addComponent(this.LabelControllerMode).addGap(44, 44, 44).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ComboBoxChannel, -2, 156, -2).addComponent(this.LabelControllerMode1, -2, 86, -2))))).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jSeparator3, -2, 420, -2)).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.LabelSetting, -2, 83, -2)).addGroup(PanelMainLayout.createSequentialGroup().addGap(51, 51, 51).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.LabelSampleState, -1, -1, Short.MAX_VALUE).addComponent(this.LabelKillState, -1, -1, Short.MAX_VALUE).addComponent(this.LabelShiftState, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.RadioButtonKill0, -1, 97, Short.MAX_VALUE).addComponent(this.RadioButtonSample0, -1, -1, Short.MAX_VALUE).addComponent(this.RadioButtonShift0, -1, -1, Short.MAX_VALUE)).addGap(30, 30, 30).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.RadioButtonShift1, -1, 92, Short.MAX_VALUE).addComponent(this.RadioButtonSample1, -1, -1, Short.MAX_VALUE).addComponent(this.RadioButtonKill1, -1, -1, Short.MAX_VALUE))).addGroup(PanelMainLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.LabeDspVersion, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelControlVersion, -2, 173, -2)).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.LabelChannelState)).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jSeparator4, -2, 420, -2)).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.LabelFirmwareVersion, -2, 252, -2).addGroup(GroupLayout.Alignment.TRAILING, PanelMainLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ButtonGet, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ButtonSet, -2, 100, -2).addGap(12, 12, 12)))).addGroup(PanelMainLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.LabelModelNo, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelTitleName, -2, 255, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ButtonInit, -2, 100, -2)).addComponent(this.LabelVersion1, -2, 488, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, PanelMainLayout.createSequentialGroup().addContainerGap(382, Short.MAX_VALUE).addComponent(this.LabelVersion, -2, 60, -2).addGap(56, 56, 56)));
        PanelMainLayout.linkSize(0, this.LabelChannelState, this.LabelControllerMode, this.LabelKillState, this.LabelSampleState);
        PanelMainLayout.setVerticalGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PanelMainLayout.createSequentialGroup().addComponent(this.LabelVersion1, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LabelVersion, -2, 11, -2).addGap(7, 7, 7).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.LabelModelNo).addComponent(this.ButtonInit, -2, 25, -2).addComponent(this.LabelTitleName, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 2, -2).addGap(17, 17, 17).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelControllerMode, -2, 20, -2).addComponent(this.LabelControllerMode1, -2, 20, -2)).addGap(10, 10, 10).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelChannelState, -2, 20, -2).addComponent(this.ComboBoxChannel, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PanelMainLayout.createSequentialGroup().addComponent(this.jSeparator3, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LabelSetting).addGap(6, 6, 6).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelShiftState, -2, 20, -2).addComponent(this.RadioButtonShift0, -2, 20, -2).addComponent(this.RadioButtonShift1, -2, 20, -2)).addGap(6, 6, 6).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelSampleState, -2, 20, -2).addComponent(this.RadioButtonSample0, -2, 20, -2).addComponent(this.RadioButtonSample1, -2, 20, -2)).addGap(5, 5, 5).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelKillState, -2, 20, -2).addComponent(this.RadioButtonKill0, -2, 20, -2).addComponent(this.RadioButtonKill1, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LabelFirmwareVersion).addGap(2, 2, 2).addGroup(PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabeDspVersion, -2, 20, -2).addComponent(this.LabelControlVersion, -2, 20, -2)).addGap(35, 35, 35)).addGroup(GroupLayout.Alignment.TRAILING, PanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ButtonGet, -2, 25, -2).addComponent(this.ButtonSet, -2, 25, -2))).addGap(10, 10, 10).addComponent(this.jPanel1, -2, -1, -2).addGap(20, 20, 20)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PanelMain, -2, 498, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PanelMain, -2, 650, -2));
        this.pack();
    }

    private void ButtonStartActionPerformed(ActionEvent evt) {
        if (this.PausedStartFlag.booleanValue()) {
            return;
        }
        if (this.DeviceStateFlag.booleanValue()) {
            this.Thread1 = new Thread(new Runnable(){

                public void run() {
                    UsbSetParaUpgDataApp.this.getUpdateFileEvent();
                    while (UsbSetParaUpgDataApp.this.PausedStartFlag.booleanValue()) {
                        if (UsbSetParaUpgDataApp.this.BootLoadModeFlag.booleanValue() && !UsbSetParaUpgDataApp.this.UpdateStartFlag.booleanValue()) {
                            UsbSetParaUpgDataApp.this.sendReadyDataMsgToControl();
                            UsbSetParaUpgDataApp.this.SendReadyCnt++;
                            if (UsbSetParaUpgDataApp.this.SendReadyCnt > 5) {
                                JOptionPane.showMessageDialog(null, "Time Out Error!!!");
                                UsbSetParaUpgDataApp.this.initEvent();
                                UsbSetParaUpgDataApp.this.closeInputOutputDevice();
                                UsbSetParaUpgDataApp.this.getMidiDeviceInfo();
                            }
                        }
                        if (!UsbSetParaUpgDataApp.this.UpdateFlag.booleanValue()) continue;
                        System.exit(0);
                    }
                }
            });
            this.Thread1.start();
        } else {
            this.TextAreaShowMsg.setForeground(Color.blue);
            this.TextAreaShowMsg.setText(" >>> No Midi Device!!!");
            JOptionPane.showMessageDialog(null, "No Midi Device!!!");
        }
    }

    private void ButtonOpenFileActionPerformed(ActionEvent evt) {
        if (this.PausedStartFlag.booleanValue()) {
            return;
        }
        this.FileDialog = new FileDialog((Frame)this, "Open File");
        this.FileDialog.setVisible(true);
        this.DirFile = this.FileDialog.getDirectory() + this.FileDialog.getFile();
        this.TextUpdateFile.setText(this.DirFile);
    }

    private void ButtonSetActionPerformed(ActionEvent evt) {
        if (this.PausedStartFlag.booleanValue()) {
            return;
        }
        if (this.DeviceStateFlag.booleanValue()) {
            if (this.ChannelState == this.ComboBoxChannel.getSelectedIndex() && (!this.ShiftState.booleanValue() && this.RadioButtonShift0.isSelected() || this.ShiftState.booleanValue() && this.RadioButtonShift1.isSelected()) && (!this.SampleState.booleanValue() && this.RadioButtonSample0.isSelected() || this.SampleState.booleanValue() && this.RadioButtonSample1.isSelected()) && (!this.KillState.booleanValue() && this.RadioButtonKill0.isSelected() || this.KillState.booleanValue() && this.RadioButtonKill1.isSelected())) {
                this.TextAreaShowMsg.setForeground(Color.blue);
                this.TextAreaShowMsg.setText(" >>> Parameter State is not changed!!!");
                JOptionPane.showMessageDialog(null, "Parameter State is not changed!!!");
                return;
            }
            this.sendShortMessage(160, 1, this.ComboBoxChannel.getSelectedIndex());
            if (this.RadioButtonShift0.isSelected()) {
                this.sendShortMessage(160, 2, 0);
            } else {
                this.sendShortMessage(160, 2, 1);
            }
            if (this.RadioButtonSample0.isSelected()) {
                this.sendShortMessage(160, 3, 0);
            } else {
                this.sendShortMessage(160, 3, 1);
            }
            this.sendShortMessage(160, 4, 1);
            if (this.RadioButtonKill0.isSelected()) {
                this.sendShortMessage(160, 5, 0);
            } else {
                this.sendShortMessage(160, 5, 1);
            }
            this.ParaStateFlag = true;
        } else {
            this.TextAreaShowMsg.setForeground(Color.blue);
            this.TextAreaShowMsg.setText(" >>> No Midi Device!!!");
            JOptionPane.showMessageDialog(null, "No Midi Device!!!");
        }
    }

    private void ButtonGetActionPerformed(ActionEvent evt) {
        if (this.PausedStartFlag.booleanValue()) {
            return;
        }
        if (this.DeviceStateFlag.booleanValue()) {
            this.sendShortMessage(160, 127, 1);
        } else {
            this.TextAreaShowMsg.setForeground(Color.blue);
            this.TextAreaShowMsg.setText(" >>> No Midi Device!!!");
            JOptionPane.showMessageDialog(null, "No Midi Device!!!");
        }
    }

    private void RadioButtonKill1ActionPerformed(ActionEvent evt) {
        this.RadioButtonKill1.setSelected(true);
        this.RadioButtonKill0.setSelected(false);
    }

    private void RadioButtonKill0ActionPerformed(ActionEvent evt) {
        this.RadioButtonKill0.setSelected(true);
        this.RadioButtonKill1.setSelected(false);
    }

    private void RadioButtonSample1ActionPerformed(ActionEvent evt) {
        this.RadioButtonSample1.setSelected(true);
        this.RadioButtonSample0.setSelected(false);
    }

    private void RadioButtonSample0ActionPerformed(ActionEvent evt) {
        this.RadioButtonSample0.setSelected(true);
        this.RadioButtonSample1.setSelected(false);
    }

    private void RadioButtonShift1ActionPerformed(ActionEvent evt) {
        this.RadioButtonShift1.setSelected(true);
        this.RadioButtonShift0.setSelected(false);
    }

    private void RadioButtonShift0ActionPerformed(ActionEvent evt) {
        this.RadioButtonShift0.setSelected(true);
        this.RadioButtonShift1.setSelected(false);
    }

    private void ComboBoxChannelActionPerformed(ActionEvent evt) {
    }

    private void ButtonInitActionPerformed(ActionEvent evt) {
        if (this.PausedStartFlag.booleanValue()) {
            return;
        }
        this.initEvent();
        this.closeInputOutputDevice();
        this.getMidiDeviceInfo();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                UsbSetParaUpgDataApp frame = new UsbSetParaUpgDataApp();
                frame.setVisible(true);
            }
        });
    }
}

